//
//  Playing_Video_FilesViewController.m
//  Playing Video Files
//
//  Created by Vandad Nahavandipoor on 16/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Playing_Video_FilesViewController.h"

@interface Playing_Video_FilesViewController(Private)
  - (void) startPlayingVideo:(id)paramSender;
  - (void) stopPlayingVideo:(id)paramSender;
@end

@implementation Playing_Video_FilesViewController

@synthesize moviePlayer;
@synthesize playButton;

/* -------------------------- */

//- (IBAction) startPlayingVideo:(id)paramSender{
//  
//  NSBundle *mainBundle = [NSBundle mainBundle];
//  
//  NSString *urlAsString = [mainBundle pathForResource:@"Sample"
//                                               ofType:@"m4v"];
//  
//  NSURL    *url = [NSURL fileURLWithPath:urlAsString];
//  
//  MPMoviePlayerController *newMoviePlayer = 
//  [[MPMoviePlayerController alloc] initWithContentURL:url];
//
//  self.moviePlayer = newMoviePlayer;
//
//  [newMoviePlayer release];
//  
//  if (self.moviePlayer != nil){
//    
//    self.moviePlayer.scalingMode = MPMovieScalingModeAspectFit;
//    
//    UIView *playerView = self.moviePlayer.view;
//
//    CGRect halfRect = self.view.frame;
//    halfRect.size.width /= 2.0f;
//    halfRect.size.height /= 2.0f;
//    
//    playerView.frame = halfRect;
//    playerView.center = self.view.center;
//    
//    [self.view addSubview:playerView];
//    
//    NSLog(@"Udało się utworzyć odtwarzacz treści wideo.");
//    
//    //[self.moviePlayer play];
//
//  } else {
//    NSLog(@"Nie udało się utworzyć odtwarzacza treści wideo.");
//  }
//  
//}

/* -------------------------- */

- (void) videoHasFinishedPlaying:(NSNotification *)paramNotification{
  
  /* Określenie powodu zatrzymania działania odtwarzacza. */
  NSNumber *reason = 
  [paramNotification.userInfo
   valueForKey:MPMoviePlayerPlaybackDidFinishReasonUserInfoKey];
  
  if (reason != nil){
    NSInteger reasonAsInteger = [reason integerValue];
    
    switch (reasonAsInteger){
      case MPMovieFinishReasonPlaybackEnded:{
        /* Odtwarzanie treści wideo zakończyło się w zwykły sposób. */
        break;
      }
      case MPMovieFinishReasonPlaybackError:{
        /* Wystąpił błąd, więc przerwano odtwarzanie treści wideo. */
        break;
      }
      case MPMovieFinishReasonUserExited:{
        /* Użytkownik zakończył działanie odtwarzacza. */
        break;
      }
    }
    
    NSLog(@"Powód zakończenia działania = %ld", (long)reasonAsInteger);
    [self stopPlayingVideo:nil];
  } /* if (reason != nil){ */
  
}

- (void) startPlayingVideo:(id)paramSender{
  
  /* Najpierw przygotowujemy adres URL pliku znajdującego się w aplikacji,
   który będzie odtworzony przez budowany odtwarzacz plików wideo. */
  NSBundle *mainBundle = [NSBundle mainBundle];
  
  NSString *urlAsString = [mainBundle pathForResource:@"Sample"
                                               ofType:@"m4v"];
  
  NSURL    *url = [NSURL fileURLWithPath:urlAsString];
  
  /* Jeżeli wcześniej udało się utworzyć odtwarzacz treści wideo,
   to w tym miejscu spróbujemy zatrzymać jego działanie. */
  if (self.moviePlayer != nil){
    [self stopPlayingVideo:nil];
  }
  
  /* Teraz tworzymy nowy odtwarzacz treści wideo, wykorzystując przygotowany wcześniej adres URL. */
  self.moviePlayer = [[MPMoviePlayerController alloc] initWithContentURL:url];
  
  if (self.moviePlayer != nil){
    
    /* Nasłuchujemy powiadomień wysyłanych przez odtwarzacz 
      po zakończeniu odtwarzania pliku z treścią. */
    [[NSNotificationCenter defaultCenter] 
     addObserver:self
     selector:@selector(videoHasFinishedPlaying:)
     name:MPMoviePlayerPlaybackDidFinishNotification
     object:self.moviePlayer];
    
    NSLog(@"Udało się utworzyć odtwarzacz treści wideo.");
    
    /* Skalujemy odtwarzacz wideo z zachowaniem odpowiednich proporcji. */
    self.moviePlayer.scalingMode = MPMovieScalingModeAspectFit;
    
    /* Rozpoczynamy odtwarzanie treści wideo w trybie pełnego ekranu. */
    [self.moviePlayer play];
        
    [self.view addSubview:self.moviePlayer.view];
    
    [self.moviePlayer setFullscreen:YES
                           animated:YES];
    
  } else {
    NSLog(@"Nie udało się utworzyć odtwarzacza treści wideo.");
  }
  
}

- (void) stopPlayingVideo:(id)paramSender {
  
  if (self.moviePlayer != nil){
    
    [[NSNotificationCenter defaultCenter]
     removeObserver:self
     name:MPMoviePlayerPlaybackDidFinishNotification
     object:self.moviePlayer];
    
    [self.moviePlayer stop];
    
    if ([self.moviePlayer.view.superview isEqual:self.view]){
      [self.moviePlayer.view removeFromSuperview];
    }
  }
  
}

- (void)viewDidLoad {
  [super viewDidLoad];
  
  self.view.backgroundColor = [UIColor whiteColor];
  
  self.playButton = [UIButton buttonWithType:UIButtonTypeRoundedRect];
  self.playButton.frame = CGRectMake(0.0f, 
                                     0.0f, 
                                     70.0f, 
                                     37.0f);
  self.playButton.center = self.view.center;
  
  self.playButton.autoresizingMask = 
    UIViewAutoresizingFlexibleTopMargin |
    UIViewAutoresizingFlexibleLeftMargin |
    UIViewAutoresizingFlexibleBottomMargin |
    UIViewAutoresizingFlexibleRightMargin;
  
  [self.playButton addTarget:self
                      action:@selector(startPlayingVideo:)
            forControlEvents:UIControlEventTouchUpInside];
  [self.playButton setTitle:@"Odtwórz"
                   forState:UIControlStateNormal];
  [self.view addSubview:self.playButton];
  
}

- (void) viewDidUnload{
  self.playButton = nil;
  [self stopPlayingVideo:nil];
  self.moviePlayer = nil;
  [super viewDidUnload];
}

- (BOOL)shouldAutorotateToInterfaceOrientation
        :(UIInterfaceOrientation)interfaceOrientation{
  return YES;
}

@end
